#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;
varying float diffuse;
varying float specular;

vec4 fragColor;
#else
in vec2 vTexCoord;
in float diffuse;
in float specular;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
        
    /* red book p. 223 */
    vec3 lambert = tColor.rgb * diffuse;
    
    fragColor = vec4(lambert + vec3(specular * tColor.a), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
